﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VIMT.VideoVisit.Messages
{
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.VIMTTmpCancelAppointmentRequest)]
    [DataContract(Name = "Appointment", Namespace = "gov.va.vamf.videoconnect/1.0")]
    public class VIMTTmpCancelAppointmentRequest : MessageBase
    {
        [DataMember]
        public string OrganizationName { get; set; }

        [DataMember]
        public Guid UserId { get; set; }

        [DataMember]
        public Guid RelatedParentId { get; set; }

        [DataMember]
        public string RelatedParentEntityName { get; set; }

        [DataMember]
        public string RelatedParentFieldName { get; set; }

        [DataMember]
        public bool LogTiming { get; set; }

        [DataMember]
        public bool LogSoap { get; set; }

        [DataMember]
        public bool Debug { get; set; }

        [DataMember]
        public VIMTTmpCancelAppointmentRequestData VIMTTmpCancelAppointmentRequestDataInfo { get; set; }
    }

    [DataContract]
    public class VIMTTmpCancelAppointmentRequestData
    {
        [DataMember]
        public string Id { get; set; }

        [DataMember]
        public string SourceSystem { get; set; }

        [DataMember]
        public VIMTTmpPersonBookingStatuses PatientBookingStatuses { get; set; }

        [DataMember]
        public string SamlToken { get; set; }
    }

    [DataContract]
    public class VIMTTmpPersonBookingStatus
    {
        [DataMember]
        public VIMTTmpPersonIdentifier Id { get; set; }

        [DataMember]
        public VIMTTmpStatus Status { get; set; }
    }

    [DataContract]
    public class VIMTTmpPersonBookingStatuses
    {
        [DataMember]
        public VIMTTmpPersonBookingStatus[] PersonBookingStatus { get; set; }
    }
}